from django.shortcuts import render, redirect
from django.http import HttpResponse
from .models import UserData, OrderInfo
from django.contrib import messages
from .send_mail import send_design_approval_email, send_order_confirmation_emails

# html_base_url = "https://mail.shadhinitcenter.com"
html_base_url = "http://127.0.0.1:8000"

def myAppHome(request):
    if request.method == "POST":
        email = request.POST.get('email')
        order_number = request.POST.get("order-number")
        
        # First, get or create OrderInfo and update email if it exists
        order_info, created = OrderInfo.objects.get_or_create(
            order_id=order_number,
            defaults={
                'order_status': 'pending',
                'order_mail': email
            }
        )
        if not created:
            order_info.order_mail = email
            order_info.save()
        
        # Create new UserData entry (always)
        data = UserData.objects.create(
            orderid=order_info,            
        )
        
        # Update images if provided
        for i, img in enumerate([
            request.FILES.get('image-upload'),
            request.FILES.get('image-upload2'),
            request.FILES.get('image-upload3')
        ], 1):
            if img:
                setattr(data, f'upload_img{i if i > 1 else ""}', img)
        
        data.save()
        
        
        # Update OrderInfo with the custom number
        order_info.order_custom_number = data.custom_number
        order_info.order_status = 'pending'
        order_info.save()
        
        # Get custom number
        custom_number = data.custom_number
        
        
        
        # Get image URLs
        image_urls = [
            data.upload_img.url if data.upload_img else None,
            data.upload_img2.url if data.upload_img2 else None,
            data.upload_img3.url if data.upload_img3 else None
        ]
        image_urls = [url for url in image_urls if url]
        
        # Send email
        send_design_approval_email(email, custom_number, image_urls, html_base_url, order_number)
        
        return redirect('infoData')

    return render(request, 'mail_home/index.html')






def orderPage(request, custom_number):
    try:
        order_data = UserData.objects.get(custom_number=custom_number)
        print(f"order_data: {order_data}")
        print(f"order_data.orderid: {order_data.orderid}")
        print(f"order_data.custom_number: {order_data.custom_number}")
        
        image_urls = [
            html_base_url + order_data.upload_img.url if order_data.upload_img else None,
            html_base_url + order_data.upload_img2.url if order_data.upload_img2 else None,
            html_base_url + order_data.upload_img3.url if order_data.upload_img3 else None
        ]
        image_urls = [url for url in image_urls if url]
        
        if request.GET.get('validate') == "true":
            order_data.orderid.order_status = 'confirmed'
            order_data.orderid.save()
            
            get_mail = order_data.orderid.order_mail
            order_data.orderid.order_custom_number = order_data.custom_number
            order_data.orderid.save()
            
            # Send confirmation emails
            send_order_confirmation_emails(order_data, image_urls, get_mail)
            
    except UserData.DoesNotExist:
        return HttpResponse("Order not found")
     
    return render(request, 'mail_home/order_info.html', 
                 {'order_data': order_data, "image_urls": image_urls})
    
    

def infoData(request):
    Data = UserData.objects.latest('id')
    data2 = OrderInfo.objects.latest('id')
    image_urls = [
                Data.upload_img.url if Data.upload_img else None,
                Data.upload_img2.url if Data.upload_img2 else None,
                Data.upload_img3.url if Data.upload_img3 else None
                ]
    image_urls = [url for url in image_urls if url]  
    return render(request, 'mail_home/info.html', {'Data': Data, "image_urls" : image_urls, "data2": data2})

 
 
 
def new_order(request):
    if request.method == "POST":
        email = request.POST.get('email')
        orderNumber = request.POST.get("orderNumber")
        data = OrderInfo(order_mail = email, order_id = orderNumber)
        data.save()
    return render(request, 'mail_home/new_order.html')



def track_Page_page(request):
    if request.method == "POST":
        email = request.POST.get('email')
        orderNumber = request.POST.get("orderNumber")

        try:
            data = OrderInfo.objects.get(order_id=orderNumber, order_mail=email)
            
            # print(f"data: {data}")
            # Render directly instead of redirecting
            return render(request, 'mail_home/track_order.html', {'data': data})
        except OrderInfo.DoesNotExist:
            messages.error(request, "Order not found")
            return redirect('track_order_form')

    return render(request, 'mail_home/track_order_form.html')
    
def track_order(request):
    return render(request, 'mail_home/track_order.html')


