from django.core.mail import EmailMultiAlternatives
import requests

html_header = """<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- <meta name="color-scheme" content="light">
    <meta name="supported-color-schemes" content="light"> -->
    <title>Your Webpage</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #F0F3EB;
            color: #002A5C;
        }

        header {
            background-color: #002A5C;
            text-align: center;
            padding: 20px;
        }

        header img {
            width: 150px;
        }

        section {
            margin: auto;
            max-width: 600px;
            border-radius: 30px;
            background-color: #002A5C;
            color: #ffffff;
            padding: 30px;
            margin-top: 20px;
        }

        section img {
            width: 100%;
            border-radius: 10px;
            margin-top: 20px;
        }

        section h1 {
            text-align: center;
        }

        .approved-badge {
            background-color: #8C7851;
            border-radius: 10px;
            box-shadow: 0 0 1px 2px #0A3262;
            padding: 10px 20px;
            color: #ffffff;
            font-weight: bold;
            text-align: center;
            margin-top: 20px;
        }

         footer {
            text-align: center;
            padding: 20px;
            background-color: #F0F3EB;
            color: #212121;
        }

        footer img {
           
            display: inline-block; 
            margin: 0 10px; 
        }

        
    </style>
</head>

<body>

    <header>
        <img src="https://rubyquality.com/cdn/shop/files/logo_habit.png?v=1693251502&width=150" alt="Logo">
    </header>

    <section>
        <h1 style="text-align:center;">La dernière ligne droite avant la réception de votre pull unique !!</h1>
        <p style="text-align:center;">Voici le premier design réalisé par notre artiste

            Pour valider ce design et qu'il soit brodé il vous suffit d'appuyer sur le bouton « valider » situé en
            dessous de votre design</p>"""



html_footer = """ <p style="text-align:center;">Si le design ne vous convient malheureusement pas voici les étapes à suivre, il
            suffit de répondre à ce mail
            en indiquant clairement vos demandes et modifications.

            Il faudra ensuite attendre 48h pour réceptionner un nouveau design!
        </p>
        <p style="text-align:center;">Merci encore pour votre commande et profitez de ce code de réduction rien que pour
            vous :)

            code : facebook15

            Pour bénéficier de 15% sur votre prochaine commande !

            À très vite sur rubyquality

        </p>
    </section>

    <footer>
        <a href="https://www.instagram.com/ruby_quality?igshid=YzVkODRmOTdmMw==" target="_blank"><img
                src="https://shadhinitcenter.com/mailImg/instagram.png" width="25" height="25" alt="Instagram"></a>
        <a href="https://www.facebook.com/profile.php?id=100095365441499" target="_blank"><img
                src="https://shadhinitcenter.com/mailImg/facebook.png" width="25" height="25" alt="Facebook"></a>
        <a href="#" target="_blank"><img src="https://shadhinitcenter.com/mailImg/gmail.png" width="25" height="25"
                alt="Email"></a>
        
            <a href="https://rubyquality.com/" target="_blank"><img
                    src="https://shadhinitcenter.com/mailImg/1.jpg" width="25" height="25" alt="Website"></a>
        

        <p>Copyright ©2023 All rights reserved.</p>
    </footer>

</body>

</html>"""



order_confirm_mail = """Bonjour, <br><br><br>

Si vous avez reçu ce mail c’est que vous avez validé votre design merci beaucoup ! <br><br><br>

Il faut compter maintenant 10-15 jours ouvrés pour la fabrication, l’emballage et l’expédition jusqu’à chez vous. <br><br><br>

Bonne journée <br><br><br>

L’équipe Rubyquality 💫 <br><br>""" # You should move HTML templates to a separate file

def send_design_approval_email(email, custom_number, image_urls, base_url, order_number):
    """Send email with design for customer approval"""
    html_image = ""
    for url in image_urls:
        html_image += f"""<img src="{base_url}{url}" alt="Banner"></br><br>"""
        
    html_order_link = f"""<a href="{base_url}/{custom_number}?validate=true"
        style="color: #ffffff; text-decoration: none;">
        <div class="approved-badge">
            Valider
        </div>
    </a>"""
    
    email_subject = f"Rubyquality Votre design est prêt ! Commande #{order_number}"
    email_from = "rubyquality.design@gmail.com"
    email_body = f"{html_header} {html_image} {html_order_link} {html_footer}"
    
    msg = EmailMultiAlternatives(
        email_subject, 
        email_body, 
        f'"Ruby Quality" <{email_from}>', 
        [email]
    )
    msg.content_subtype = 'html'
    msg.send()

def send_order_confirmation_emails(order_data, image_urls, get_mail):
    """Send confirmation emails to customer and print service"""
    email_from = "rubyquality.design@gmail.com"
    email_subject = f"Rubyquality Order Placed - {order_data.orderid}"

    # Customer email
    customer_email = EmailMultiAlternatives(
        email_subject,
        order_confirm_mail,
        f'"Ruby Quality" <{email_from}>',
        [get_mail]
    )
    customer_email.content_subtype = 'html'
    
    # Print service email
    print_service_email = EmailMultiAlternatives(
        email_subject,
        "",
        f'"Ruby Quality" <{email_from}>',
        ['flexfulfills.annie@gmail.com']
    )

    # Attach images to both emails
    for url in image_urls:
        response = requests.get(url)
        filename = url.split('/')[-1]
        content_type = response.headers.get('content-type')
        attachment_data = (filename, response.content, content_type)
        
        customer_email.attach(*attachment_data)
        print_service_email.attach(*attachment_data)

    # Send emails
    customer_email.send()
    print_service_email.send()
