from django.contrib import admin
from unfold.admin import ModelAdmin
from .models import UserData, OrderInfo

@admin.register(OrderInfo)
class OrderInfoAdmin(ModelAdmin):
    list_display = ['order_id', 'order_mail', 'order_custom_number', 'order_status', 'created_at', 'status_updated_at']
    list_filter = ['order_status']
    search_fields = ['order_id', 'order_mail']
    readonly_fields = ['status_updated_at', 'created_at']

@admin.register(UserData)
class UserDataAdmin(ModelAdmin):
    list_display = ['custom_number', 'get_order_id', 'get_order_mail', 'get_order_status', 'get_created_at']
    list_filter = ['orderid__order_status']
    search_fields = ['orderid__order_id', 'orderid__order_mail']
    readonly_fields = ['custom_number']
    
    def get_order_mail(self, obj):
        return obj.orderid.order_mail
    get_order_mail.short_description = 'Email'
    
    def get_order_status(self, obj):
        return obj.orderid.order_status
    get_order_status.short_description = 'Status'
    
    def get_created_at(self, obj):
        return obj.orderid.created_at.strftime("%Y-%m-%d %H:%M:%S") if obj.orderid.created_at else '-'
    get_created_at.short_description = 'Created At'
    
    def get_order_id(self, obj):
        return obj.orderid.order_id
    get_order_id.short_description = 'Order ID'